@extends('layouts.admin')

@section('page-title')
    {{ __('Create Category') }}
@endsection

@push('scripts')
    <script src="{{ asset('assets/js/jscolor.js') }}"></script>
@endpush

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="post" class="needs-validation" action="{{route('admin.category.store')}}">
                        @csrf
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3">{{ __('Name') }}</label>
                            <div class="col-sm-12 col-md-7">
                                <input type="text" placeholder="{{ __('Name of the Category') }}" name="name" class="form-control {{ $errors->has('name') ? ' is-invalid' : '' }}" value="{{ old('name') }}">
                                <div class="invalid-feedback">
                                    {{ $errors->first('name') }}
                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3">{{ __('Color') }}</label>
                            <div class="col-sm-12 col-md-1">
                                <input name="color" class="jscolor form-control {{ $errors->has('color') ? ' is-invalid' : '' }}" value="#255ff7">
                                <div class="invalid-feedback">
                                    {{ $errors->first('color') }}
                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"></label>
                            <div class="col-sm-12 col-md-7" id="enabled-button">
                                <button class="btn-submit" id="button-click"><span>{{ __('Add') }}</span></button>
                            </div>
                            <div class="col-sm-12 col-md-7" id="disabled-button" style="display: none">
                                <button class="btn-submit" type="button">
                                    <span>
                                        <div class="spinner-border" role="status" style="width: 1rem; height: 1rem;">
                                            <span class="sr-only">Loading...</span>
                                        </div> &nbsp; {{ __('Add') }}
                                    </span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        const button = document.getElementById("button-click");
        button.addEventListener("click", (event) => {
            const enabled = document.getElementById("enabled-button");
            enabled.style.display = "none";

            const disabled = document.getElementById("disabled-button");
            disabled.style.display = "block";
        })
    </script>
@endpush