<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Create Faq')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="post" class="needs-validation" action="<?php echo e(route('admin.faq.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Title')); ?></label>
                            <div class="col-sm-12 col-md-7">
                                <input type="text" placeholder="<?php echo e(__('Title of the Faq')); ?>" name="title" class="form-control <?php echo e($errors->has('title') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('title')); ?>" autofocus>
                                <div class="invalid-feedback">
                                    <?php echo e($errors->first('title')); ?>

                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Description')); ?></label>
                            <div class="col-sm-12 col-md-7">
                                <textarea name="description" class="form-control <?php echo e($errors->has('description') ? ' is-invalid' : ''); ?>" placeholder="<?php echo e(__('Enter Description')); ?>" ><?php echo e(old('description')); ?></textarea>
                                <div class="invalid-feedback">
                                    <?php echo e($errors->first('description')); ?>

                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"></label>
                            <div class="col-sm-12 col-md-7" id="enabled-button">
                                <button class="btn btn-submit" id="button-click">
                                    <span> <?php echo e(__('Add')); ?> </span>
                                </button>
                            </div>
                            <div class="col-sm-12 col-md-7" id="disabled-button" style="display: none">
                                <button class="btn btn-submit" type="button">
                                    <span>
                                        <div class="spinner-border" role="status" style="width: 1rem; height: 1rem;">
                                            <span class="sr-only">Loading...</span>
                                        </div> &nbsp; <?php echo e(__('Add')); ?>

                                    </span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="//cdn.ckeditor.com/4.12.1/basic/ckeditor.js"></script>
    <script src="<?php echo e(asset('assets/js/editorplaceholder.js')); ?>"></script>
    <script>
        CKEDITOR.replace('description', {
            // contentsLangDirection: 'rtl',
            extraPlugins: 'editorplaceholder',
            editorplaceholder: '<?php echo e(__('Start Text here..')); ?>'
        });
    </script>

    <script>
        const button = document.getElementById("button-click");
        button.addEventListener("click", (event) => {
            const enabled = document.getElementById("enabled-button");
            enabled.style.display = "none";

            const disabled = document.getElementById("disabled-button");
            disabled.style.display = "block";
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/support/resources/views/admin/faq/create.blade.php ENDPATH**/ ?>