<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Create Category')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/jscolor.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="post" class="needs-validation" action="<?php echo e(route('admin.category.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Name')); ?></label>
                            <div class="col-sm-12 col-md-7">
                                <input type="text" placeholder="<?php echo e(__('Name of the Category')); ?>" name="name" class="form-control <?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('name')); ?>" required>
                                <div class="invalid-feedback">
                                    <?php echo e($errors->first('name')); ?>

                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Color')); ?></label>
                            <div class="col-sm-12 col-md-1">
                                <input name="color" class="jscolor form-control <?php echo e($errors->has('color') ? ' is-invalid' : ''); ?>" value="#255ff7">
                                <div class="invalid-feedback">
                                    <?php echo e($errors->first('color')); ?>

                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label class="col-form-label form-control-label text-md-right col-12 col-md-3 col-lg-3"></label>
                            <div class="col-sm-12 col-md-7">
                                <button class="btn-submit"><span><?php echo e(__('Add')); ?></span></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sigtiesc/soporte.sigties.com/resources/views/admin/category/create.blade.php ENDPATH**/ ?>