<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Reply Ticket')); ?> - <?php echo e($ticket->ticket_id); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('multiple-action-button'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-tickets')): ?>
        <a class="btn btn-xs btn-white btn-icon-only width-auto" type="button" data-toggle="collapse" href="#ticket-info"><?php echo e(__('Edit')); ?></a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-tickets')): ?>
        <?php echo e(Form::model($ticket, array('route' => array('admin.tickets.update', $ticket->id), 'id' => 'ticket-info', 'class' => 'collapse mt-3', 'method' => 'PUT','enctype'=>'multipart/form-data'))); ?>

        <div class="row">
            <div class="col-lg-8 col-md-12 col-sm-12 col-xs-12">
                <div class="card">
                    <div class="card-header"><h6><?php echo e(__('Ticket Information')); ?></h6></div>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="require form-control-label"><?php echo e(__('Name')); ?></label>
                                <input class="form-control <?php echo e((!empty($errors->first('name')) ? 'is-invalid' : '')); ?>" type="text" name="name" required="" value="<?php echo e($ticket->name); ?>" placeholder="<?php echo e(__('Name')); ?>">
                                <?php if($errors->has('name')): ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($errors->first('name')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="require form-control-label"><?php echo e(__('Email')); ?></label>
                                <input class="form-control <?php echo e((!empty($errors->first('email')) ? 'is-invalid' : '')); ?>" type="email" name="email" required="" value="<?php echo e($ticket->email); ?>" placeholder="<?php echo e(__('Email')); ?>">
                                <?php if($errors->has('email')): ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($errors->first('email')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="require form-control-label"><?php echo e(__('Category')); ?></label>
                                <select class="form-control select2 <?php echo e((!empty($errors->first('category')) ? 'is-invalid' : '')); ?>" name="category" required="">
                                    <option value=""><?php echo e(__('Select Category')); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php if($ticket->category == $category->id): ?> selected <?php endif; ?>><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('category')): ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($errors->first('category')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="require form-control-label"><?php echo e(__('Status')); ?></label>
                                <select class="form-control select2 <?php echo e((!empty($errors->first('status')) ? 'is-invalid' : '')); ?>" name="status" required="">
                                    <option value="In Progress" <?php if($ticket->status == 'In Progress'): ?> selected <?php endif; ?>><?php echo e(__('In Progress')); ?></option>
                                    <option value="On Hold" <?php if($ticket->status == 'On Hold'): ?> selected <?php endif; ?>><?php echo e(__('On Hold')); ?></option>
                                    <option value="Closed" <?php if($ticket->status == 'Closed'): ?> selected <?php endif; ?>><?php echo e(__('Closed')); ?></option>
                                </select>
                                <?php if($errors->has('status')): ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($errors->first('status')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="require form-control-label"><?php echo e(__('Subject')); ?></label>
                                <input class="form-control <?php echo e((!empty($errors->first('subject')) ? 'is-invalid' : '')); ?>" type="text" name="subject" required="" value="<?php echo e($ticket->subject); ?>" placeholder="<?php echo e(__('Subject')); ?>">
                                <?php if($errors->has('subject')): ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($errors->first('subject')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="require form-control-label"><?php echo e(__('Description')); ?></label>
                                <textarea name="description" class="form-control ckdescription <?php echo e((!empty($errors->first('description')) ? 'is-invalid' : '')); ?>"><?php echo $ticket->description; ?></textarea>
                                <?php if($errors->has('description')): ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($errors->first('description')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>

                            <?php if(!$customFields->isEmpty()): ?>
                                <?php echo $__env->make('admin.customFields.formBuilder', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <a class="btn btn-submit gray-bg mr-2" href="<?php echo e(route('admin.tickets.index')); ?>"><?php echo e(__('Cancel')); ?></a>
                        <button class="btn btn-submit" type="submit"><?php echo e(__('Update')); ?></button>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12">
                <div class="card">
                    <div class="card-header">
                        <h6><?php echo e(__('Attachments')); ?><small class="d-block">(<?php echo e(__('You can select multiple files')); ?>)</small></h6>
                    </div>
                    <div class="card-body">
                        <div class="choose-file form-group">
                            <label for="file" class="form-control-label">
                                <div><?php echo e(__('Choose File Here')); ?></div>
                                <input type="file" class="form-control <?php echo e($errors->has('attachments') ? ' is-invalid' : ''); ?>" multiple="" name="attachments[]" id="file" data-filename="multiple_file_selection">
                                <div class="invalid-feedback">
                                    <?php echo e($errors->first('attachments')); ?>

                                </div>
                            </label>
                        </div>
                    </div>
                    <div class="mx-4">
                        <p class="multiple_file_selection mb-0"></p>
                        <ul class="list-group list-group-flush w-100">
                            <?php $attachments = json_decode($ticket->attachments); ?>
                            <?php if(!empty($attachments)): ?>
                                <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item">
                                        <?php echo e($attachment); ?>

                                        <a download="" href="<?php echo e(asset(Storage::url('tickets/'.$ticket->ticket_id."/".$attachment))); ?>" class="edit-icon" title="<?php echo e(__('Download')); ?>"><i class="fa fa-download"></i></a>
                                        <a class="text-danger ml-1" title="<?php echo e(__('Delete')); ?>" onclick="(confirm('Are You Sure?')?(document.getElementById('user-form-<?php echo e($index); ?>').submit()):'');"><i class="nav-icon i-Close-Window font-weight-bold"></i></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <?php echo e(Form::close()); ?>


        <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <form method="post" id="user-form-<?php echo e($index); ?>" action="<?php echo e(route('admin.tickets.attachment.destroy',[$ticket->id,$index])); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
            </form>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <div class="row mt-3">
        <div class="col-lg-8 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h6>
                        <span class="text-left">
                            <?php echo e($ticket->name); ?> <small>(<?php echo e($ticket->created_at->diffForHumans()); ?>)</small>
                            <span class="d-block"><small><?php echo e($ticket->email); ?></small></span>
                        </span>
                        </h6>
                        <small>
                        <span class="text-right">
                            <?php echo e(__('Status')); ?> : <span class="badge <?php if($ticket->status == 'In Progress'): ?>badge-warning <?php elseif($ticket->status == 'On Hold'): ?> badge-danger <?php else: ?> badge-success <?php endif; ?>"><?php echo e(__($ticket->status)); ?></span>
                        </span>
                            <span class="d-block">
                            <?php echo e(__('Category')); ?> : <span class="badge"><?php echo e($ticket->tcategory ? $ticket->tcategory->name : '-'); ?></span>
                        </span>
                        </small>
                    </div>
                    <div class="row">
                        <?php $__currentLoopData = $customFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-6">
                                <small>
                                    <span class="text-right">
                                        <?php echo e($field->name); ?> : <?php echo (isset($ticket->customField[$field->id]) && !empty($ticket->customField[$field->id])) ? $ticket->customField[$field->id] : '-'; ?>

                                    </span>
                                </small>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="card-body">
                    <div><?php echo $ticket->description; ?></div>
                    <?php $attachments = json_decode($ticket->attachments); ?>
                    <?php if(count($attachments)): ?>
                        <div class="m-1">
                            <h6><?php echo e(__('Attachments')); ?> :</h6>
                            <ul class="list-group list-group-flush">
                                <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item">
                                        <?php echo e($attachment); ?> <a download="" href="<?php echo e(asset(Storage::url('tickets/'.$ticket->ticket_id."/".$attachment))); ?>" class="edit-icon py-1 ml-2" title="<?php echo e(__('Download')); ?>"><i class="fas fa-download"></i></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <?php $__currentLoopData = $ticket->conversions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card">
                    <div class="card-header"><h6><?php echo e($conversion->replyBy()->name); ?> <small>(<?php echo e($conversion->created_at->diffForHumans()); ?>)</small></h6></div>
                    <div class="card-body">
                        <div><?php echo $conversion->description; ?></div>
                        <?php $attachments = json_decode($conversion->attachments); ?>
                        <?php if(count($attachments)): ?>
                            <div class="m-1">
                                <h6><?php echo e(__('Attachments')); ?> :</h6>
                                <ul class="list-group list-group-flush">
                                    <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item">
                                            <?php echo e($attachment); ?><a download="" href="<?php echo e(asset(Storage::url('tickets/'.$ticket->ticket_id."/".$attachment))); ?>" class="edit-icon py-1 ml-2" title="<?php echo e(__('Download')); ?>"><i class="fa fa-download"></i></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reply-tickets')): ?>
            <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12">
                <div class="card">
                    <div class="card-header"><h6><?php echo e(__('Add Reply')); ?></h6></div>
                    <form method="post" action="<?php echo e(route('admin.conversion.store',$ticket->id)); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">

                            <div class="form-group">
                                <label class="require form-control-label"><?php echo e(__('Description')); ?></label>
                                <textarea name="reply_description" class="form-control ckdescription" required></textarea>
                                <div class="invalid-feedback d-block">
                                    <?php echo e($errors->first('reply_description')); ?>

                                </div>
                            </div>
                            <div class="form-group file-group mb-5">
                                <label class="require form-control-label"><?php echo e(__('Attachments')); ?></label>
                                <label class="form-control-label"><small>(<?php echo e(__('You can select multiple files')); ?>)</small></label>
                                <div class="choose-file form-group">
                                    <label for="file" class="form-control-label">
                                        <div><?php echo e(__('Choose File Here')); ?></div>
                                        <input type="file" class="form-control <?php echo e($errors->has('reply_attachments') ? ' is-invalid' : ''); ?>" multiple="" name="reply_attachments[]" id="file" data-filename="multiple_reply_file_selection">
                                        <div class="invalid-feedback">
                                            <?php echo e($errors->first('reply_attachments')); ?>

                                        </div>
                                    </label>
                                </div>
                            </div>
                            <p class="multiple_reply_file_selection"></p>
                        </div>

                        <div class="card-footer text-right">
                            <button class="btn-submit" type="submit"><?php echo e(__('Submit')); ?></button>
                        </div>
                    </form>
                </div>
                <div class="card mt-4">
                    <div class="card-header"><h6><?php echo e(__('Note')); ?></h6></div>
                    <form method="post" action="<?php echo e(route('admin.note.store',$ticket->id)); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <div class="form-group">
                                <textarea name="note" class="form-control ckdescription"><?php echo e($ticket->note); ?></textarea>
                                <div class="invalid-feedback">
                                    <?php echo e($errors->first('note')); ?>

                                </div>
                            </div>
                        </div>

                        <div class="card-footer text-right">
                            <button class="btn-submit" type="submit"><?php echo e(__('Add Note')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="//cdn.ckeditor.com/4.12.1/basic/ckeditor.js"></script>
    <script src="<?php echo e(asset('assets/js/editorplaceholder.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $.each($('.ckdescription'), function (i, editor) {
                CKEDITOR.replace(editor, {
                    // contentsLangDirection: 'rtl',
                    extraPlugins: 'editorplaceholder',
                    editorplaceholder: editor.placeholder
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sigtiesc/soporte.sigties.com/resources/views/admin/tickets/edit.blade.php ENDPATH**/ ?>